/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.core.instrumentation.buffer;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;

public class BoundedCharArrayWriter
extends CharArrayWriter {
    private final int maxCapacity;

    BoundedCharArrayWriter(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    BoundedCharArrayWriter(int maxCapacity, int initialSize) {
        super(initialSize);
        this.maxCapacity = maxCapacity;
    }

    @Override
    public void write(int c) {
        if (this.size() == this.maxCapacity) {
            return;
        }
        super.write(c);
    }

    @Override
    public void write(char[] c, int off, int len) {
        int size = this.size();
        if (size + len > this.maxCapacity) {
            super.write(c, off, this.maxCapacity - size);
            return;
        }
        super.write(c, off, len);
    }

    @Override
    public void write(String str, int off, int len) {
        int size = this.size();
        if (size + len > this.maxCapacity) {
            super.write(str, off, this.maxCapacity - size);
            return;
        }
        super.write(str, off, len);
    }

    @Override
    public void writeTo(Writer out) throws IOException {
        super.writeTo(out);
    }

    @Override
    public CharArrayWriter append(CharSequence csq) {
        String s = csq == null ? "null" : csq.toString();
        this.write(s, 0, s.length());
        return this;
    }

    @Override
    public CharArrayWriter append(CharSequence csq, int start, int end) {
        String s = (csq == null ? "null" : csq).subSequence(start, end).toString();
        this.write(s, 0, s.length());
        return this;
    }

    @Override
    public CharArrayWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(String str) throws IOException {
        if (str == null) {
            str = "null";
        }
        this.write(str, 0, str.length());
    }
}

