/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.core.instrumentation.buffer;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import java.io.IOException;
import java.util.Map;
import org.hypertrace.agent.core.TriFunction;
import org.hypertrace.agent.core.filter.FilterResult;
import org.hypertrace.agent.core.instrumentation.HypertraceEvaluationException;
import org.hypertrace.agent.core.instrumentation.buffer.BoundedCharArrayWriter;

public class CharBufferSpanPair {
    public final Span span;
    public final Map<String, String> headers;
    private final BoundedCharArrayWriter buffer;
    private final TriFunction<Span, String, Map<String, String>, FilterResult> filter;
    private boolean bufferCaptured;

    public CharBufferSpanPair(Span span, BoundedCharArrayWriter buffer, TriFunction<Span, String, Map<String, String>, FilterResult> filter, Map<String, String> headers) {
        this.span = span;
        this.buffer = buffer;
        this.headers = headers;
        this.filter = filter;
    }

    public void captureBody(AttributeKey<String> attributeKey) {
        if (this.bufferCaptured) {
            return;
        }
        this.bufferCaptured = true;
        String requestBody = this.buffer.toString();
        this.span.setAttribute(attributeKey, requestBody);
        FilterResult filterResult = this.filter.apply(this.span, requestBody, this.headers);
        if (filterResult.shouldBlock()) {
            throw new HypertraceEvaluationException(filterResult);
        }
    }

    public void writeToBuffer(byte singleByte) {
        this.bufferCaptured = false;
        this.buffer.write(singleByte);
    }

    public void writeToBuffer(char[] c, int offset, int len) {
        this.bufferCaptured = false;
        this.buffer.write(c, offset, len);
    }

    public void writeToBuffer(char[] c) throws IOException {
        this.bufferCaptured = false;
        this.buffer.write(c);
    }

    public void writeLine(String line) throws IOException {
        this.bufferCaptured = false;
        this.buffer.write(line);
    }
}

