/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.filter;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.List;
import java.util.Map;
import org.hypertrace.agent.core.filter.FilterResult;
import org.hypertrace.agent.filter.api.Filter;

class MultiFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(MultiFilter.class);
    private final List<Filter> filters;

    public MultiFilter(List<Filter> filters) {
        this.filters = filters;
    }

    @Override
    public FilterResult evaluateRequestHeaders(Span span, Map<String, String> headers) {
        for (Filter filter : this.filters) {
            try {
                FilterResult filterResult = filter.evaluateRequestHeaders(span, headers);
                if (!filterResult.shouldBlock()) continue;
                return filterResult;
            }
            catch (Throwable t) {
                logger.warn("Throwable thrown while evaluating Request headers for filter {}", (Object)filter.getClass().getName(), (Object)t);
            }
        }
        return new FilterResult(false, 0, "");
    }

    @Override
    public FilterResult evaluateRequestBody(Span span, String body, Map<String, String> headers) {
        for (Filter filter : this.filters) {
            try {
                FilterResult filterResult = filter.evaluateRequestBody(span, body, headers);
                if (!filterResult.shouldBlock()) continue;
                return filterResult;
            }
            catch (Throwable t) {
                logger.warn("Throwable thrown while evaluating Request body for filter {}", (Object)filter.getClass().getName(), (Object)t);
            }
        }
        return new FilterResult(false, 0, "");
    }
}

