#!/bin/bash

# Check if an argument is provided
if [ $# -lt 4 ]; then
    echo "Usage: $0 <layer-name> <layer-description> <zip-file> <region>"
    exit 1
fi

# Set your variables
LAYER_NAME="$1"
LAYER_DESCRIPTION="$2"
LAYER_ZIP_FILE="$3"
REGION="$4"
RUNTIME="provided provided.al2"

# Publish the Layer
LAYER_VERSION=$(aws lambda publish-layer-version \
    --layer-name $LAYER_NAME \
    --description "$LAYER_DESCRIPTION" \
    --license-info "Appsentinels" \
    --zip-file fileb://$LAYER_ZIP_FILE \
    --compatible-runtimes $RUNTIME \
    --region $REGION \
    --query 'Version' \
    --output text)

echo "Published Layer Version: $LAYER_VERSION"

# Get the Layer ARN
LAYER_ARN=$(aws lambda list-layer-versions \
    --layer-name $LAYER_NAME \
    --region $REGION \
    --query 'LayerVersions[0].LayerVersionArn' \
    --output text)

echo "Layer ARN: $LAYER_ARN"

# Make the layer public (optional)
aws lambda add-layer-version-permission \
    --layer-name $LAYER_NAME \
    --version-number $LAYER_VERSION \
    --statement-id public \
    --action lambda:GetLayerVersion \
    --principal '*' \
    --region $REGION

echo "Layer made public"
