#!/bin/bash

# Exit on error
set -e

# Check if an argument is provided
if [ $# -lt 2 ]; then
    echo "Usage: $0 <Layers path> <region>"
    exit 1
fi

# Directory containing the layers (zip file)
LAYERS_DIR="$1"
AWS_REGION="$2"
PYTHONLAYER_ZIPFILE="python_wrapper.zip"
PYTHON_WRAPPER_NAME="appsentinels-wrapper"
PYTHON_WRAPPER_DESC="AppSentinels wrapper to capture HTTP logs"
GOLAYER_ZIPFILE="go_extension.zip"
GOLAYER_NAME="appsentinels-log-server"
GOLAYER_DESC="AppSentinels Log server extension to capture and send the logs"

# Script to publish the layer in AWS
PUBLISH="$LAYERS_DIR/publish_extension.sh"

# Publish the python wrapper
echo "Publishing python wrapper..."
source $PUBLISH $PYTHON_WRAPPER_NAME "$PYTHON_WRAPPER_DESC" $PYTHONLAYER_ZIPFILE $AWS_REGION
echo "python wrapper published, please note the ARN"

# Publish the go extension
echo "Publishing log server extension..."
source $PUBLISH $GOLAYER_NAME "$GOLAYER_DESC" $GOLAYER_ZIPFILE $AWS_REGION
echo "Log server extesnion published, please note the ARN"
