/*
 * Decompiled with CFR 0.152.
 */
package org.appsentinels;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.http.HttpClient;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.rest.AbstractHandler;
import org.appsentinels.AsyncLogSenderPool;

public class AppSentinelsLogger
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(AppSentinelsLogger.class);
    private HttpClient httpClient;
    private String edgeControllerUri = "http://localhost:9004/mergedlog";
    private String skipHttpMethods = "OPTIONS,HEAD";
    private Set<String> skipHttpMethodsSet = new HashSet<String>();
    private String collectContentTypes = "json,xml,form,graphql";
    private List<String> collectContentTypesList = new ArrayList<String>();
    private String skipExtensions = "svg,txt,png,PNG,jpg,jpeg,io,tff,woff,woff2,ico,css,pdf,html,mp4,php,ajax,js,gif,tiff,ttf,docx,svg,wasm,aspx";
    private Set<String> skipExtensionsSet = new HashSet<String>();
    private Pattern skipExtensionsPattern = null;
    private int maxPayloadSize = 32768;
    private int requestTimeoutMs = 500;
    private int connectTimeoutMs = 1000;
    private String instanceName = "wso2";
    private String hostname = "wso2-host";
    private int logSenderThreads = 2;
    private AsyncLogSenderPool asyncLogSenderPool;
    private ThreadLocal<Boolean> payloadTruncated = ThreadLocal.withInitial(() -> false);

    public void setInstanceName(String name) {
        if (name != null && !name.trim().isEmpty()) {
            this.instanceName = name.trim();
        }
        log.info((Object)("Instance name set to: " + this.instanceName));
    }

    public void setHostname(String host) {
        if (host != null && !host.trim().isEmpty()) {
            this.hostname = host.trim();
        }
        log.info((Object)("Hostname set to: " + this.hostname));
    }

    public void setRequestTimeoutMs(String timeout) {
        try {
            if (timeout != null && !timeout.trim().isEmpty()) {
                this.requestTimeoutMs = Integer.parseInt(timeout.trim());
                this.updateAsyncLogSenderConfiguration();
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)("Invalid requestTimeoutMs value: " + timeout), (Throwable)e);
        }
        log.info((Object)("Request timeout set to: " + this.requestTimeoutMs + "ms"));
    }

    public void setConnectTimeoutMs(String timeout) {
        try {
            if (timeout != null && !timeout.trim().isEmpty()) {
                this.connectTimeoutMs = Integer.parseInt(timeout.trim());
                this.updateAsyncLogSenderConfiguration();
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)("Invalid connectTimeoutMs value: " + timeout), (Throwable)e);
        }
        log.info((Object)("Connect timeout set to: " + this.connectTimeoutMs + "ms"));
    }

    public void setMaxPayloadSize(String size) {
        try {
            if (size != null && !size.trim().isEmpty()) {
                this.maxPayloadSize = Integer.parseInt(size.trim());
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)("Invalid maxPayloadSize value: " + size), (Throwable)e);
        }
        log.info((Object)("Max payload size set to: " + this.maxPayloadSize));
    }

    public void setSkipHttpMethods(String methods) {
        if (methods != null && !methods.trim().isEmpty()) {
            this.skipHttpMethods = methods.trim();
        }
        this.skipHttpMethodsSet.clear();
        for (String m : this.skipHttpMethods.split(",")) {
            if (m.trim().isEmpty()) continue;
            this.skipHttpMethodsSet.add(m.trim().toUpperCase());
        }
        log.info((Object)("Skip HTTP Methods set to: " + String.valueOf(this.skipHttpMethodsSet)));
    }

    public void setCollectContentTypes(String types) {
        if (types != null && !types.trim().isEmpty()) {
            this.collectContentTypes = types.trim();
        }
        this.collectContentTypesList.clear();
        if (!this.collectContentTypes.isEmpty()) {
            for (String t : this.collectContentTypes.split(",")) {
                if (t.trim().isEmpty()) continue;
                this.collectContentTypesList.add(t.trim().toLowerCase());
            }
        }
        log.info((Object)("Collect Content-Types set to: " + String.valueOf(this.collectContentTypesList.isEmpty() ? "ALL (universal capture)" : this.collectContentTypesList)));
    }

    public void setSkipExtensions(String extensions) {
        if (extensions != null && !extensions.trim().isEmpty()) {
            this.skipExtensions = extensions.trim();
        }
        this.skipExtensionsSet.clear();
        this.skipExtensionsPattern = null;
        if (!this.skipExtensions.isEmpty()) {
            ArrayList<String> extensionsList = new ArrayList<String>();
            for (String ext : this.skipExtensions.split(",")) {
                if (ext.trim().isEmpty()) continue;
                Object extension = ext.trim().toLowerCase();
                if (!((String)extension).startsWith(".")) {
                    extension = "." + (String)extension;
                }
                this.skipExtensionsSet.add((String)extension);
                String extForRegex = ((String)extension).substring(1).replaceAll("([\\[\\]{}()*+?.\\\\^$|])", "\\\\$1");
                extensionsList.add(extForRegex);
            }
            if (!extensionsList.isEmpty()) {
                String regexPattern = "\\.(" + String.join((CharSequence)"|", extensionsList) + ")(\\?.*)?$";
                this.skipExtensionsPattern = Pattern.compile(regexPattern, 2);
                log.debug((Object)("Skip Extensions regex pattern: " + regexPattern));
            }
        }
        log.info((Object)("Skip Extensions set to: " + String.valueOf(this.skipExtensionsSet)));
    }

    private void ensureSkipExtensionsInitialized() {
        if (this.skipExtensionsPattern == null && !this.skipExtensions.isEmpty()) {
            log.debug((Object)"Initializing skip extensions with defaults");
            this.setSkipExtensions(null);
        }
    }

    private void ensureCollectContentTypesInitialized() {
        if (this.collectContentTypesList.isEmpty() && !this.collectContentTypes.isEmpty()) {
            log.debug((Object)"Initializing collect content types with defaults");
            this.setCollectContentTypes(null);
        }
    }

    public void setLogSenderThreads(String threads) {
        try {
            int n;
            if (threads != null && !threads.trim().isEmpty() && (n = Integer.parseInt(threads.trim())) > 0 && n != this.logSenderThreads) {
                this.logSenderThreads = n;
                this.recreateAsyncLogSenderPool();
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)("Invalid logSenderThreads value: " + threads), (Throwable)e);
        }
        log.info((Object)("Log sender threads set to: " + this.logSenderThreads));
    }

    private void updateAsyncLogSenderConfiguration() {
        if (this.asyncLogSenderPool != null) {
            this.asyncLogSenderPool.updateConfiguration(this.edgeControllerUri, this.connectTimeoutMs, this.requestTimeoutMs);
            log.debug((Object)"Updated AsyncLogSenderPool configuration");
        }
    }

    private void recreateAsyncLogSenderPool() {
        if (this.asyncLogSenderPool != null) {
            this.asyncLogSenderPool.shutdown();
        }
        this.asyncLogSenderPool = new AsyncLogSenderPool(this.edgeControllerUri, this.connectTimeoutMs, this.requestTimeoutMs, this.logSenderThreads);
        log.info((Object)("Recreated AsyncLogSenderPool with " + this.logSenderThreads + " threads"));
    }

    public AppSentinelsLogger() {
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(1000L)).build();
        this.initializeEdgeControllerUri();
        this.setSkipHttpMethods(System.getProperty("skipHttpMethods", this.skipHttpMethods));
        this.setCollectContentTypes(System.getProperty("collectContentTypes", this.collectContentTypes));
        this.setSkipExtensions(System.getProperty("skipExtensions", this.skipExtensions));
        this.setMaxPayloadSize(System.getProperty("maxPayloadSize", String.valueOf(this.maxPayloadSize)));
        this.setRequestTimeoutMs(System.getProperty("requestTimeoutMs", String.valueOf(this.requestTimeoutMs)));
        this.setConnectTimeoutMs(System.getProperty("connectTimeoutMs", String.valueOf(this.connectTimeoutMs)));
        this.setInstanceName(System.getProperty("instanceName", this.instanceName));
        this.setHostname(System.getProperty("hostname", this.hostname));
        if (this.hostname.equals("wso2-host")) {
            try {
                this.hostname = InetAddress.getLocalHost().getHostName();
                log.info((Object)("Auto-detected hostname: " + this.hostname));
            }
            catch (Exception e) {
                this.hostname = "wso2-host";
                log.error((Object)("Failed to detect hostname, using default: " + this.hostname), (Throwable)e);
            }
        }
        this.setLogSenderThreads(System.getProperty("logSenderThreads", String.valueOf(this.logSenderThreads)));
        this.asyncLogSenderPool = new AsyncLogSenderPool(this.edgeControllerUri, this.connectTimeoutMs, this.requestTimeoutMs, this.logSenderThreads);
        log.info((Object)("CustomAPIAuthenticationHandler initialized successfully with URI: " + this.edgeControllerUri));
    }

    private void initializeEdgeControllerUri() {
        String configuredUri = null;
        configuredUri = System.getProperty("edgeControllerUri");
        if (configuredUri == null || configuredUri.trim().isEmpty()) {
            configuredUri = System.getenv("EDGE_CONTROLLER_URI");
        }
        if (configuredUri != null && !configuredUri.trim().isEmpty()) {
            this.edgeControllerUri = this.addDefaultQueryParams(configuredUri.trim());
            log.info((Object)("Edge controller URI configured from system/environment: " + this.edgeControllerUri));
        } else {
            this.edgeControllerUri = this.addDefaultQueryParams(this.edgeControllerUri);
            log.info((Object)("Using default edge controller URI: " + this.edgeControllerUri));
        }
    }

    public void setEdgeControllerUri(String uri) {
        if (uri != null && !uri.trim().isEmpty()) {
            this.edgeControllerUri = this.addDefaultQueryParams(uri.trim());
            this.updateAsyncLogSenderConfiguration();
            log.info((Object)("Edge controller URI set via WSO2 property injection: " + this.edgeControllerUri));
        }
    }

    private Map getTransportHeaders(org.apache.synapse.MessageContext messageContext) {
        return (Map)((Axis2MessageContext)messageContext).getAxis2MessageContext().getProperty("TRANSPORT_HEADERS");
    }

    private String addDefaultQueryParams(String uri) {
        if (uri == null || uri.trim().isEmpty()) {
            return uri;
        }
        String trimmedUri = uri.trim();
        boolean hasSensor = trimmedUri.contains("sensor=wso2");
        boolean hasCap = trimmedUri.contains("cap=nohb");
        if (hasSensor && hasCap) {
            return trimmedUri;
        }
        StringBuilder uriBuilder = new StringBuilder(trimmedUri);
        boolean hasQueryParams = trimmedUri.contains("?");
        if (!hasSensor) {
            if (!hasQueryParams) {
                uriBuilder.append("?sensor=wso2");
                hasQueryParams = true;
            } else {
                uriBuilder.append("&sensor=wso2");
            }
        }
        if (!hasCap) {
            if (!hasQueryParams) {
                uriBuilder.append("?cap=nohb");
            } else {
                uriBuilder.append("&cap=nohb");
            }
        }
        return uriBuilder.toString();
    }

    private byte[] getPayload(org.apache.synapse.MessageContext messageContext) {
        this.ensureCollectContentTypesInitialized();
        if (!this.collectContentTypesList.isEmpty()) {
            Map headers = this.getTransportHeaders(messageContext);
            String contentType = null;
            if (headers != null) {
                Object ct = headers.get("Content-Type");
                if (ct == null) {
                    ct = headers.get("content-type");
                }
                if (ct != null) {
                    contentType = ct.toString().toLowerCase();
                }
            }
            if (contentType != null) {
                boolean shouldCollect = false;
                for (String filter : this.collectContentTypesList) {
                    if (!contentType.contains(filter)) continue;
                    shouldCollect = true;
                    break;
                }
                if (!shouldCollect) {
                    log.debug((Object)("Skipping payload collection due to content-type filter: " + contentType));
                    this.payloadTruncated.set(false);
                    return null;
                }
            }
        }
        MessageContext axis2MC = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        byte[] payloadBytes = null;
        try {
            Class<?> bufferClass;
            Method positionMethod;
            Integer position;
            Class<?> pipeClass;
            Method getBufferMethod;
            Object bufferObj;
            Object pipeObj = axis2MC.getProperty("pass-through.pipe");
            if (pipeObj != null && (bufferObj = (getBufferMethod = (pipeClass = pipeObj.getClass()).getMethod("getBuffer", new Class[0])).invoke(pipeObj, new Object[0])) != null && (position = (Integer)(positionMethod = (bufferClass = bufferObj.getClass()).getMethod("position", new Class[0])).invoke(bufferObj, new Object[0])) != null && position > 0) {
                Field[] fields;
                for (Field field : fields = bufferClass.getDeclaredFields()) {
                    boolean exceedsMaxPayloadSize;
                    if (field.getType() != ByteBuffer.class) continue;
                    field.setAccessible(true);
                    Object byteBufferObj = field.get(bufferObj);
                    if (!(byteBufferObj instanceof ByteBuffer)) continue;
                    ByteBuffer bb = (ByteBuffer)byteBufferObj;
                    int dataSize = Math.min(position, bb.limit());
                    if (dataSize <= 0) continue;
                    boolean hitBufferLimit = dataSize >= bb.capacity();
                    boolean bl = exceedsMaxPayloadSize = dataSize >= this.maxPayloadSize;
                    if (hitBufferLimit || exceedsMaxPayloadSize) {
                        if (hitBufferLimit) {
                            log.debug((Object)("Payload size (" + dataSize + ") hits buffer limit (" + bb.capacity() + "). Skipping collection."));
                        }
                        if (exceedsMaxPayloadSize) {
                            log.debug((Object)("Payload size (" + dataSize + ") exceeds maxPayloadSize (" + this.maxPayloadSize + "). Skipping collection."));
                        }
                        this.payloadTruncated.set(true);
                        return null;
                    }
                    int bbPos = bb.position();
                    bb.position(0);
                    payloadBytes = new byte[dataSize];
                    bb.get(payloadBytes);
                    bb.position(bbPos);
                    this.payloadTruncated.set(false);
                    log.debug((Object)("Extracted payload from pass-through pipe, size: " + payloadBytes.length));
                    return payloadBytes;
                }
            }
            if (payloadBytes != null) {
                this.payloadTruncated.set(false);
                return payloadBytes;
            }
            log.debug((Object)"No payload found using any extraction method (upstream payload preserved)");
            return null;
        }
        catch (Exception e) {
            log.debug((Object)("Payload extraction failed: " + e.getMessage()));
            this.payloadTruncated.set(false);
            return null;
        }
    }

    public boolean handleRequest(org.apache.synapse.MessageContext messageContext) {
        try {
            MessageContext axisMC = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
            String httpMethod = String.valueOf(axisMC.getProperty("HTTP_METHOD"));
            if (this.skipHttpMethodsSet.contains(httpMethod.toUpperCase())) {
                log.debug((Object)("Skipping handler for HTTP method: " + httpMethod));
                return true;
            }
            messageContext.setProperty("T1_REQUEST_IN", (Object)String.valueOf(System.currentTimeMillis()));
            HashMap<String, Object> request_log = new HashMap<String, Object>();
            log.debug((Object)"handleRequest: Custom API Authentication Handler initiated");
            String requestURI = (String)messageContext.getProperty("REST_FULL_REQUEST_PATH");
            this.ensureSkipExtensionsInitialized();
            if (this.skipExtensionsPattern != null && requestURI != null && this.skipExtensionsPattern.matcher(requestURI).find()) {
                log.debug((Object)("Skipping handler for static file extension in URI: " + requestURI));
                return true;
            }
            request_log.put("Uri", requestURI);
            request_log.put("Method", httpMethod);
            request_log.put("Version", "HTTP 1.1");
            log.debug((Object)("Processing request - Method: " + httpMethod + ", URI: " + requestURI));
            byte[] payload = this.getPayload(messageContext);
            String encoded_req_body = payload != null ? Base64.getEncoder().encodeToString(payload) : "";
            request_log.put("Body64", encoded_req_body);
            Map req_headers = this.getTransportHeaders(messageContext);
            log.debug((Object)("Request headers: " + req_headers.toString()));
            HashMap<String, String> req_header_hashmap = new HashMap<String, String>();
            if (this.payloadTruncated.get().booleanValue()) {
                req_header_hashmap.put("x-as-req-truncated-body", "true");
            }
            for (Object key : req_headers.keySet()) {
                String headerKey = (String)key;
                String headerValue = (String)req_headers.get(key);
                req_header_hashmap.put(headerKey, headerValue);
            }
            request_log.put("Headers", req_header_hashmap);
            log.debug((Object)("Request log: " + ((Object)request_log).toString()));
            messageContext.setProperty("as_request_context", request_log);
            MessageContext axis2MsgContext = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
            String _clientIp = (String)axis2MsgContext.getProperty("REMOTE_ADDR");
            log.debug((Object)("Processing request from Client IP: " + _clientIp));
            messageContext.setProperty("as_client_ip", (Object)_clientIp);
            return true;
        }
        catch (Exception ex) {
            log.error((Object)"Error occurred in handleRequest - continuing with request processing", (Throwable)ex);
            return true;
        }
    }

    public boolean handleResponse(org.apache.synapse.MessageContext messageContext) {
        try {
            if (messageContext.getProperty("as_request_context") == null) {
                log.debug((Object)"Skipping response processing: as_request_context not found in messageContext");
                return true;
            }
            HashMap<String, Object> response_log = new HashMap<String, Object>();
            HashMap<String, String> resp_header_hashmap = new HashMap<String, String>();
            Map resp_headers = this.getTransportHeaders(messageContext);
            for (Object key : resp_headers.keySet()) {
                String headerKey = (String)key;
                String headerValue = (String)resp_headers.get(key);
                resp_header_hashmap.put(headerKey, headerValue);
            }
            resp_header_hashmap.put("X-As-Sensor-Instance", this.instanceName);
            resp_header_hashmap.put("X-As-Sensor-Hostname", this.hostname);
            response_log.put("Headers", resp_header_hashmap);
            log.debug((Object)("Response headers: " + resp_headers.toString()));
            MessageContext axis2MsgContext = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
            String _status = String.valueOf(axis2MsgContext.getProperty("HTTP_SC"));
            response_log.put("status", Integer.parseInt(_status));
            byte[] respPayload = this.getPayload(messageContext);
            String encoded_resp_body = respPayload != null ? Base64.getEncoder().encodeToString(respPayload) : "";
            response_log.put("Body64", encoded_resp_body);
            if (this.payloadTruncated.get().booleanValue()) {
                resp_header_hashmap.put("x-as-resp-truncated-body", "true");
            }
            HashMap<String, Object> merged_log = new HashMap<String, Object>();
            merged_log.put("Response", response_log);
            long t1RequestArrival = Long.parseLong(messageContext.getProperty("T1_REQUEST_IN").toString());
            merged_log.put("Started_at", t1RequestArrival);
            long t4ResponseDeparture = System.currentTimeMillis();
            HashMap<String, Long> latencies = new HashMap<String, Long>();
            latencies.put("request", t4ResponseDeparture - t1RequestArrival);
            merged_log.put("latencies", latencies);
            Map request_log = new HashMap();
            request_log = (Map)messageContext.getProperty("as_request_context");
            merged_log.put("Request", request_log);
            String client_ip = (String)messageContext.getProperty("as_client_ip");
            merged_log.put("client_ip", client_ip);
            log.debug((Object)("Merged log data: " + ((Object)merged_log).toString()));
            log.debug((Object)("Queueing API log for async request processing completed in " + (t4ResponseDeparture - t1RequestArrival) + "ms"));
            String json = new ObjectMapper().writeValueAsString(merged_log);
            this.asyncLogSenderPool.queueLog(json);
        }
        catch (Exception ex) {
            log.error((Object)"Error occurred in handleResponse", (Throwable)ex);
        }
        return true;
    }
}

