/*
 * Decompiled with CFR 0.152.
 */
package org.appsentinels;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncLogSender {
    private static final Log log = LogFactory.getLog(AsyncLogSender.class);
    private final BlockingQueue<String> logQueue;
    private final ExecutorService singleThreadExecutor;
    private volatile HttpClient httpClient;
    private volatile String edgeControllerUri;
    private volatile int requestTimeoutMs;
    private volatile boolean shutdown = false;
    private final int workerId;

    public AsyncLogSender(int workerId, String edgeControllerUri, int connectTimeoutMs, int requestTimeoutMs) {
        this.workerId = workerId;
        this.edgeControllerUri = edgeControllerUri;
        this.requestTimeoutMs = requestTimeoutMs;
        this.logQueue = new LinkedBlockingQueue<String>();
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(connectTimeoutMs)).build();
        this.singleThreadExecutor = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "AppSentinels-AsyncLogSender-" + workerId);
            t.setDaemon(true);
            return t;
        });
        this.singleThreadExecutor.submit(this::processLogs);
        log.info((Object)("AsyncLogSender-" + workerId + " initialized with URI: " + edgeControllerUri));
    }

    public void updateConfiguration(String edgeControllerUri, int connectTimeoutMs, int requestTimeoutMs) {
        this.edgeControllerUri = edgeControllerUri;
        this.requestTimeoutMs = requestTimeoutMs;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(connectTimeoutMs)).build();
        log.info((Object)("AsyncLogSender-" + this.workerId + " configuration updated - URI: " + edgeControllerUri + ", connectTimeout: " + connectTimeoutMs + "ms, requestTimeout: " + requestTimeoutMs + "ms"));
    }

    public void queueLog(String logJson) {
        boolean added;
        if (!this.shutdown && !(added = this.logQueue.offer(logJson))) {
            log.warn((Object)("AsyncLogSender-" + this.workerId + " failed to queue log - queue may be full"));
        }
    }

    private void processLogs() {
        while (!this.shutdown && !Thread.currentThread().isInterrupted()) {
            try {
                String logJson = this.logQueue.take();
                this.sendLogToEdgeController(logJson);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                log.error((Object)("Error in AsyncLogSender-" + this.workerId + " worker thread"), (Throwable)e);
            }
        }
        log.info((Object)("AsyncLogSender-" + this.workerId + " worker thread stopped"));
    }

    private void sendLogToEdgeController(String json) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.edgeControllerUri)).timeout(Duration.ofMillis(this.requestTimeoutMs)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json, StandardCharsets.UTF_8)).version(HttpClient.Version.HTTP_1_1).build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() >= 400) {
                log.warn((Object)("AsyncLogSender-" + this.workerId + " - Edge controller returned status: " + response.statusCode()));
            }
        }
        catch (Exception e) {
            log.info((Object)("AsyncLogSender-" + this.workerId + " failed to send log to edge controller: " + this.edgeControllerUri), (Throwable)e);
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.singleThreadExecutor.shutdown();
        try {
            if (!this.singleThreadExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.singleThreadExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.singleThreadExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        log.info((Object)("AsyncLogSender-" + this.workerId + " shutdown completed"));
    }

    public int getQueueSize() {
        return this.logQueue.size();
    }

    public int getWorkerId() {
        return this.workerId;
    }
}

