/*
 * Decompiled with CFR 0.152.
 */
package org.appsentinels;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appsentinels.AsyncLogSender;

public class AsyncLogSenderPool {
    private static final Log log = LogFactory.getLog(AsyncLogSenderPool.class);
    private final List<AsyncLogSender> senders;
    private final AtomicInteger roundRobinCounter = new AtomicInteger(0);
    private volatile boolean shutdown = false;

    public AsyncLogSenderPool(String edgeControllerUri, int connectTimeoutMs, int requestTimeoutMs, int threadCount) {
        this.senders = new ArrayList<AsyncLogSender>(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            AsyncLogSender sender = new AsyncLogSender(i + 1, edgeControllerUri, connectTimeoutMs, requestTimeoutMs);
            this.senders.add(sender);
        }
        log.info((Object)("AsyncLogSenderPool initialized with " + threadCount + " worker threads"));
    }

    public void queueLog(String logJson) {
        if (!this.shutdown && !this.senders.isEmpty()) {
            int index = Math.abs(this.roundRobinCounter.getAndIncrement()) % this.senders.size();
            this.senders.get(index).queueLog(logJson);
        }
    }

    public void updateConfiguration(String edgeControllerUri, int connectTimeoutMs, int requestTimeoutMs) {
        if (!this.shutdown) {
            for (AsyncLogSender sender : this.senders) {
                sender.updateConfiguration(edgeControllerUri, connectTimeoutMs, requestTimeoutMs);
            }
            log.info((Object)("Updated configuration for all " + this.senders.size() + " AsyncLogSender workers"));
        }
    }

    public void shutdown() {
        this.shutdown = true;
        for (AsyncLogSender sender : this.senders) {
            sender.shutdown();
        }
        log.info((Object)"AsyncLogSenderPool shutdown completed");
    }

    public int getTotalQueueSize() {
        return this.senders.stream().mapToInt(AsyncLogSender::getQueueSize).sum();
    }

    public int getWorkerCount() {
        return this.senders.size();
    }

    public List<Integer> getWorkerQueueSizes() {
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        for (AsyncLogSender sender : this.senders) {
            sizes.add(sender.getQueueSize());
        }
        return sizes;
    }
}

